export default function Sidebar({
  history,
  onSelectHistory,
  onFetchHistory,
  onDeleteHistory,
}) {
  const getMethodColor = (method) => {
    switch (method) {
      case "GET":
        return "text-green-500";
      case "POST":
        return "text-yellow-500";
      case "PUT":
        return "text-blue-500";
      case "DELETE":
        return "text-red-500";
      case "PATCH":
        return "text-purple-500";
      default:
        return "text-gray-500";
    }
  };

  return (
    <div className="flex flex-col h-full">
      <div className="p-4 border-b border-gray-800 flex justify-between items-center bg-gray-900">
        <h2 className="font-semibold text-2xl tracking-wider text-white">
          Endpoint<span className="text-orange-500">X</span>
        </h2>
        <button
          onClick={onFetchHistory}
          className="text-xs bg-gray-800 hover:bg-gray-700 text-gray-300 px-2 py-1 rounded transition-colors border border-gray-700"
        >
          Refresh
        </button>
      </div>

      <div className="flex-1 overflow-y-auto custom-scrollbar">
        {history.length === 0 ? (
          <div className="p-8 text-center text-gray-500 text-sm">
            No history found.
          </div>
        ) : (
          <ul className="flex flex-col">
            {history.map((req) => (
              <li
                key={req._id}
                onClick={() => onSelectHistory(req)}
                className="cursor-pointer p-3 hover:bg-gray-800 border-b border-gray-800/50 transition-colors flex items-center gap-3 group"
              >
                <span
                  className={`text-[10px] font-bold w-12 text-right ${getMethodColor(req.method)}`}
                >
                  {req.method}
                </span>
                <span className="truncate text-sm text-gray-400 group-hover:text-gray-200">
                  {req.url}
                </span>
                <button
                  onClick={() => onDeleteHistory(req._id)}
                  className="text-xs bg-gray-800 hover:bg-red-500 cursor-pointer text-gray-300 px-2 py-1 rounded transition-colors border border-gray-700"
                >
                  Delete
                </button>
              </li>
            ))}
          </ul>
        )}
      </div>
    </div>
  );
}
